#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct SegmentStablo {
    vector<int> xor_stablo, and_stablo;
    int n;

    SegmentStablo(const vector<int>& niz, bool je_xor) {
        n = niz.size();
        int velicina = 2 * n;
        if (je_xor) xor_stablo.assign(velicina, 0);
        else and_stablo.assign(velicina, ~0);
        for (int i = 0; i < n; i++) {
            if (je_xor) xor_stablo[n + i] = niz[i];
            else and_stablo[n + i] = niz[i];
        }
        for (int i = n - 1; i > 0; --i) {
            if (je_xor) xor_stablo[i] = xor_stablo[i * 2] ^ xor_stablo[i * 2 + 1];
            else and_stablo[i] = and_stablo[i * 2] & and_stablo[i * 2 + 1];
        }
    }

    int upit(int l, int r, bool je_xor) {
        int rezultat = je_xor ? 0 : ~0;
        l += n, r += n;
        while (l < r) {
            if (l & 1) {
                rezultat = je_xor ? rezultat ^ xor_stablo[l] : rezultat & and_stablo[l];
                l++;
            }
            if (r & 1) {
                --r;
                rezultat = je_xor ? rezultat ^ xor_stablo[r] : rezultat & and_stablo[r];
            }
            l /= 2, r /= 2;
        }
        return rezultat;
    }
};

int main() {
    int n;
    cin >> n;
    vector<int> niz_a(n), niz_b(n);
    for (int& x : niz_a) cin >> x;
    for (int& x : niz_b) cin >> x;

    SegmentStablo xor_stablo(niz_a, true), and_stablo(niz_b, false);
    int maks_vrednost = 0;

    for (int l = 0; l < n; ++l) {
        for (int r = l; r < n; ++r) {
            int vrednost = xor_stablo.upit(l, r + 1, true) * and_stablo.upit(l, r + 1, false);
            maks_vrednost = max(maks_vrednost, vrednost);
        }
    }

    cout << maks_vrednost << endl;
    return 0;
}